Rem
Rem $Header: drop_georaster_table.sql 05-aug-2004.09:30:23 wexu Exp $
Rem
Rem drop_georaster_table.sql
Rem
Rem Copyright (c) 2003, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      drop_georaster_table.sql
Rem
Rem    DESCRIPTION
Rem      basic cleanup procedure
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        08/05/04 - RDT must be unique 
Rem    qxie        07/22/03 - comments
Rem    qxie        03/27/03 - qxie_ship1
Rem    qxie        03/27/03 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


-------------------------------------------------------------------
-- drop georaster table 
--
-- The GeoRaster DML trigger is automatically dropped when
-- you drop the georaster table. So the basic step is simply
-- to drop the georaster table.
-------------------------------------------------------------------

drop table georaster_table purge;

-- all entries should be gone
select table_name, rdt_table_name
   from user_sdo_geor_sysdata
   where table_name = 'GEORASTER_TABLE'
   order by rdt_table_name;


-------------------------------------------------------------------
-- clean up RDTs
--
-- It's user's responsibility to clean up any un-used RDT tables.
-- GeoRaster will not drop the RDT tables.
-- But before you drop RDT tables, you must make sure they are not
-- in use anymore. Note, one RDT table can be shared by many
-- GeoRaster objects.
-------------------------------------------------------------------

drop table st_rdt_1 purge;
drop table st_rdt_2 purge;
drop table st_rdt_3 purge;
drop table st_rdt_4 purge;


